-- TARS Export control for DCS World
--
-- Parameters for the TARS export core component are listed below.
-- The TARS Control panel will manage these values for you if you use it.

-- Guard mode selection
gTARSGuardSelect = 1

-- Change this if you need to have TARS listen on a different port.
gTARSDCSHost = "0.0.0.0"
gTARSDCSPort = 48201

-- Change this to the computer you run TS3 on, if it runs on a different machine.
gTARSTS3Host = "127.0.0.1"
gTARSTS3Port = 48101

-- TARS logfile location
local lfs = require('lfs')
gTARSLogfile = lfs.writedir() .. "Logs\\TARS.log";

-- DO NOT EDIT BELOW THIS LINE
package.path  = package.path..";.\\LuaSocket\\?.lua"
package.cpath = package.cpath..";.\\LuaSocket\\?.dll"
socket = require("socket")
dofile(lfs.writedir().."TARS\\tarsexporter.luac")
dofile(lfs.writedir().."TARS\\tarscore.luac")

-- Prev Export functions.
PrevExport = {}
PrevExport.LuaExportStart = LuaExportStart
PrevExport.LuaExportStop = LuaExportStop
PrevExport.LuaExportAfterNextFrame = LuaExportAfterNextFrame

gTARSLastUpdateTime = 0

-- Lua Export Functions
LuaExportStart = function()

	-- Initialize TARS
    TARSInit()
    
    -- Chain previously-included export as necessary
    if PrevExport.LuaExportStart then
        PrevExport.LuaExportStart()
    end
end

LuaExportStop = function()

	-- Shut down TARS
    TARSShutdown()

    -- Chain previously-included export as necessary
    if PrevExport.LuaExportStop then
        PrevExport.LuaExportStop()
    end
end

debugOnce = false;

gTARSCoroutineInitialized = false;
function LuaExportAfterNextFrame()

    local curTime = LoGetModelTime()
    local scheduleTime

    -- Initialize once after first frame to avoid sync issues
    if not gTARSCoroutineInitialized then

        scheduleTime = curTime + 1
        gTARSLastUpdateTime = scheduleTime

        gTARSCoroutineInitialized = true

        TARSLog("TARS update cycle scheduled at modeltime "..scheduleTime)
    end

    if curTime >= gTARSLastUpdateTime then
        TARSCycle()
        gTARSLastUpdateTime = curTime + gTARSUpdateInterval
    end

    -- Chain previously-included export as necessary
    if PrevExport.LuaExportAfterNextFrame then
        PrevExport.LuaExportAfterNextFrame()
    end
end
